/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.ZeroPage;

public class CPY
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte op_n = new HwByte(operand.getByte().getNumber());
        HwByte result = cpu.getY();
        Flags6502 flags = cpu.getFlags();
        flags.setCarry(result.getNumber() >= op_n.getNumber());
        op_n.not();
        op_n.inc(1);
        result.inc((int)op_n.getNumber());
        flags.setNZFromValue(result);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "CPY";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(192, this, new Immediate());
        cset.defineCommand(196, this, new ZeroPage());
        cset.defineCommand(204, this, new Absolute());
    }
}

